import { Link, useLocation } from 'react-router-dom'
import { Tent } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app-wrapper-outdoor">
      <header className="header-outdoor">
        <div className="container">
          <div className="header-content-outdoor">
            <Link to="/" className="logo-outdoor">
              <div className="logo-icon-wrapper-outdoor">
                <Tent className="logo-icon-outdoor" size={28} />
              </div>
              <span className="logo-text-outdoor">OUTDOOR RENT</span>
            </Link>
            <nav className="nav-outdoor">
              <Link 
                to="/" 
                className={`nav-link-outdoor ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои аренды
              </Link>
              <Link 
                to="/rent" 
                className={`nav-link-outdoor ${location.pathname === '/rent' ? 'active' : ''}`}
              >
                Арендовать
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content-outdoor">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout

